Execbase	= 4
openlib		=-408
closelib	=-414
mode_old	=1005
openscreen	=-198
closescreen	=-66
openwindow	=-204
closewindow	=-72
AllocFX		=-$1e
FreeFX		=-$24
InstallFXA	=-$2a
RemoveFX	=-$30
AnimateFX	=-$36
FindVP		=-$3c

	incdir	asminclude:
	include	exec/exec_lib.i
	include dos/dos_lib.i
	include graphics/graphics_lib.i
	include graphics/specialfx.i
	include	intuition/intuition_lib.i
	bsr	getmemory
	tst.l	d0
	beq.s	end
	bsr	init
	bsr	start
	rts
end:
	rts
init:
	bsr.w	task_find
	bsr.w	intlib_open
	bsr.w	gfxlib_open
	bsr.w	doslib_open
	bsr.w	screen_open
;	bsr.w	window_open
;	bsr.w	con_open
	bsr.s	int_open
	bsr.s	FX_do
	rts

int_open:
	move.l	4,a6
	lea	COP_IS(pc),a1
	moveq	#4,d0
	jsr	_LVOAddIntServer(a6)
	rts

int_close:
	move.l	4,a6
	lea	COP_IS(pc),a1
	moveq	#5,d0
	jsr	_LVORemIntServer(a6)
	rts
FX_do:
	move.l	screenhd,a0
	add.l	#44,a0		; pointer to viewport
	move.l	#SFX_IntControl,d0
	moveq	#1,d1		; number of elements
	move.l	#FXError,a1	; pointer to ULONG - for errors
	move.l	SFXBase,a6
	jsr	AllocFX(a6)	; get memory etc.
	move.l	d0,FX_handle	; returns pointer to FX
	move.l	d0,FXAddy
	beq.s	.end		; leave if problem
	move.l	d0,a0
	move.l	(a0),a0
	move.w	#0,(a0)		; int at line 0.
	move.w	#0,2(a0)
	move.l	GFXBase,a0
	add.l	#34,a0		; get active view
	move.l	(a0),a0
	move.l	screenhd,a1
	add.l	#44,a1
	move.l	#FXTags,a2	; pointer to TAGS
	jsr	InstallFXA(a6)	; install copper interrupt
	move.l	d0,FX_DHandle
	move.l	intbase,a6
	move.l	screenhd,a0
	jsr	_LVOMakeScreen(a6)
	jsr	_LVORethinkDisplay(a6)
	move.l	FX_DHandle,a0
	jsr	AnimateFX(a6)
.end	rts

FX_Close:
	move.l	FX_DHandle,a0
	move.l	SFXBase,a6
	jsr	RemoveFX(a6)
	move.l	FX_Handle,a0
	jsr	FreeFX(a6)
	rts
	
con_open:
	move.l	#consolname,d1
	move.l	#1005,d2
	move.l	dosbase,a6
	jsr	_LVOOpen(a6)
	move.l	d0,conhandle
	rts

con_close:
	move.l	conhandle,d1
	move.l	dosbase,a6
	jsr	_LVOclose(a6)
	rts
qu:
	bsr.s	FX_Close
	bsr.s	freememory
;	bsr.s	con_close
;	bsr.w	window_close
	bsr.w	screen_close
	bsr.w	int_close
	bsr.w	gfxlib_close
	bsr.w	intulib_close
	bra.w	doslib_close
	

getmemory:
	move.l	#262144,d0
	move.l	#$10001,d1
	move.l	execbase,a6
	jsr	_LVOAllocMem(a6)	
	move.l	d0,address
	beq.s	Fail
	move.l	#262144,d0
	move.l	execbase,a6
	move.l	address,a1
	jsr	_LVOFreeMem(a6)
	move.l	address,d0
	add.l	#$10000,d0
	move.w	#0,d0
	move.l	d0,a1
	move.l	#192*1024,d0
	move.l	execbase,a6
	jsr	_LVOAllocAbs(a6)
	move.l	d0,address
	beq.s	getMemory
Fail:
	rts

freememory:
	move.l	address,a1
	move.l	#192*1024,d0
	move.l	execbase,a6
	jsr	_LVOFreeMem(a6)
	rts

task_find:
	sub.l	a1,a1
	move.l	execbase,a6
	jsr	_LVOfindtask(a6)
	move.l	d0,taskpt
	rts

intlib_open:
	move.l	execbase,a6
	lea	intuname(pc),a1
	jsr	openlib(a6)
	move.l	d0,intbase
	rts

intulib_close:
	move.l	execbase,a6
	move.l	intbase(pc),a1
	jsr	closelib(a6)
	rts

doslib_open:
	move.l	execbase,a6
	lea	dosname(pc),a1
	jsr	openlib(a6)
	move.l	d0,dosbase
	rts

doslib_close:
	move.l	execbase,a6
	move.l	dosbase(pc),a1
	jsr	closelib(a6)
	rts

gfxlib_open:
	move.l	execbase,a6
	lea	gfxname(pc),a1
	jsr	openlib(a6)
	move.l	d0,gfxbase
	move.l	execbase,a6
	lea	sfxname(pc),a1
	jsr	openlib(a6)
	move.l	d0,sfxbase
	rts

gfxlib_close:
	move.l	execbase,a6
	move.l	gfxbase(pc),a1
	jsr	closelib(a6)
	move.l	execbase,a6
	move.l	sfxbase(pc),a1
	jsr	closelib(a6)
	rts

screen_open:
	lea.l	screen_defs(pc),a0
	move.l	intbase(pc),a6
	jsr	openscreen(a6)
	move.l	d0,screenhd
	rts

screen_close:
	move.l	screenhd(pc),a0
	move.l	intbase(pc),a6
	jsr	closescreen(a6)
	rts

window_open:
	move.l	intbase(pc),a6
	lea	window_defs(pc),a0
	jsr	openwindow(a6)
	move.l	d0,windowhd
	move.l	taskpt(pc),a0
	move.l	$b8(a0),taskoldwin
	move.l	d0,$b8(a0)
	rts

window_close:
	move.l	taskpt(pc),a0
	move.l	taskoldwin(pc),$b8(a0)
	move.l	intbase(pc),a6
	move.l	windowhd(pc),a0
	jsr	closewindow(a6)
	rts

openfile:
	move.l	#mode_old,d2
	move.l	dosbase,a6
	jsr	_LVOOpen(a6)
	move.l	d0,filehd
	rts

closefile:
	move.l	dosbase,a6
	move.l	filehd,d1
	jsr	_LVOClose(a6)
	rts

readdata:
	move.l	dosbase,a6
	move.l	filehd,d1
	jsr	_LVORead(a6)
	rts

loadROMs:
	move.l	#kernel,d1
	bsr.s	openfile
	move.l	#$2000,d3
	move.l	address,d2
	add.l	#$e000,d2
	bsr.s	readdata
	bsr.s	closefile
	move.l	address,a1
	move.l	a1,a2		;copy roms
	add.l	#$12000,a2
	add.l	#$e000,a1
	moveq	#0,d0
.loop1	move.l	(a1,d0.l),(a2,d0.l)
	addq.l	#4,d0
	cmp.l	#$2000,d0
	bcs.s	.loop1
	
	move.l	#basic,d1
	bsr.w	openfile
	move.l	#$2000,d3
	move.l	address,d2
	add.l	#$a000,d2
	bsr.s	readdata
	bsr.w	closefile
	move.l	address,a1
	move.l	a1,a2		;copy roms
	add.l	#$10000,a2
	add.l	#$a000,a1
	moveq	#0,d0
.loop2	move.l	(a1,d0.l),(a2,d0.l)
	addq.l	#4,d0
	cmp.l	#$2000,d0
	bcs.s	.loop2

	move.l	#char,d1
	bsr.w	openfile
	move.l	#$1000,d3
	move.l	address,d2
	add.l	#$14000,d2
	bsr.w	readdata
	bsr.w	closefile

	rts

codecopy:
	lea	code,a0
	move.l	address,a1
	add.l	#$c000,a1
.loop
	cmp.b	#255,(a0)
	beq.s	.fin
.cont
	move.b	(a0)+,(a1)+
	bra.s	.loop
.fin
	cmp.b	#255,1(a0)
	bne.s	.cont
	rts

ISInterrupt:
	move.l	#1,ISData
	move.w	Col0,$DFF180
	move.w	Col1,$DFF1A0
	moveq	#0,d0
	rts

SetUpScreen:
	move.l	screenhd,a0
	move.l	$d0(a0),a0
	add.l	#1240,a0	; NB: Defines where screen border stops!!
	move.l	#1999,d0
.lp	move.l	#-1,(a0)+
	dbra	d0,.lp
	rts

SetUpScreenLookup:
	lea	ScrLUT,a0
	move.l	#999,d2
	moveq	#0,d0
	
.lp
	move.l	d0,d6		; character offset from top left
	move.l	d6,d4
	divu	#40,d6
	and.l	#$ffff,d6
	mulu	#40,d6
	sub.l	d6,d4
	lsl.l	#3,d6
	add.l	d4,d6
	add.l	#1240,d6
	move.w	d6,(a0)+
	addq.l	#1,d0
	dbra	d2,.lp
	rts

start:
	bsr.s	SetUpScreenLookup
	bsr.s	SetUpScreen
	bsr.w	loadROMs
	bsr.w	codecopy
	move.l	address,a6
	add.l	#$20000,a6
	bsr	InitSRAM
	move.l	screenhd,a0
	lea	44(a0),a0
	moveq	#32,d0
	lea	colour64(pc),a1
	move.l	gfxbase,a6
	jsr	_LVOLoadRGB4(a6)
	move.l	address,a4		;address of Alloc'ed mem
	move.l	a4,a6
	add.l	#$20000,a6		;a6 = ^ SRAM
	moveq	#0,d0			;d0=ac,d1=xr,d2=yr,d3=sr,a4=64pc
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	moveq	#0,d4
	move.l	a4,d6
	lea	$1ff(a4),a3
	add.l	#$fce2,a4
	move.l	a4,a0			;a3=64SP,a0=64MAR
	move.w	#$d018,d5
	move.b	#21,(a4,d5.l)
	lea	WriteBase,a2		; a2 is WriteBase
start2:
;	tst.l	ISData
;	bne	DOIRQ
start1:
	moveq	#0,d7
	move.b	(a4)+,d7
	btst	#6,$bfe001
	bne.s	.skip
	btst.b	#10,$dff016
	beq.s	done
.skip
	lea	table,a5
	move.l	(a5,d7.w*4),a5
	jsr	(a5)
;	cmp.l	#0,a5
;	beq	qu
	move.w	a4,d5
	cmp.w	#$bc9b,d5
	beq.s	stop
	cmp.w	#$ff,d7
	bne.s	.ov
	move.w	a0,d4
	move.b	(a6,d4.l),d7
	move.l	(a2,d7.w*4),a5	; fill SRAM check here *****
	jmp	(a5)
.ov	cmp.w	#$d012,d6
	beq.s	RasterR
	bra.s	start2
stop:
	bra.s	start2
Done:
	btst	#6,$bfe001
	beq	qu
	bne.s	done

RasterR:
	move.w	$dff006,d5	; OPTIMIZE **********************
	lsr.w	#8,d5
	move.b	d5,(a0)
	bra.w	start2

RasterW:
				; IMPLEMENT *********************
	bra.w	start2

; Shadow ram, contains routine identifiers showing what each byte of
; memory is attached to.
; Numbers are used to index into routine pointers stored in two tables
; One table for read, one for write
; a1 - read base	a2 - write base
; Currently:
;	0 - no action
;	1 - KROMS - $e000-$ffff
;	2 - VIC Raster Control $d012
;	3 - BROMS - $a000-$bfff
;	4 - VIC screen
;	5 - MCR $d018
;	6 - Border colour $d020
;	7 - Screen colour $d021
; PRE:	a6 MUST point to SRAM base
; POST:	Assume ALL registers except a6 trashed!

InitSRam:
	move.l	#8192-1,d0	; clear 8k of memory
	move.l	#$a000,d1
	move.l	#$e000,d2
.lp	move.b	#1,(a6,d2.l)
	move.b	#3,(a6,d1.l)
	addq.l	#1,d1
	addq.l	#1,d2
	dbra	d0,.lp
	move.l	#$d012,d7
	move.b	#2,(a6,d7.l)	; Raster Control
	move.l	#$d018,d7
	move.b	#5,(a6,d7.l)	; MCR
	move.l	#$d020,d7
	move.b	#6,(a6,d7.l)	; Border colour
	move.l	#$d021,d7
	move.b	#7,(a6,d7.l)	; Screen colour
	move.l	#$5d,d7
	move.b	#8,(a6,d7.l)

; Init VIC screen addr
	move.l	#1024,d7
	move.w	#249,d6
	move.l	#$04040404,a5
.lp2	move.l	a5,(a6,d7.l)
	addq.l	#4,d7
	dbra	d6,.lp2
	rts

KROMs:
	move.l	a0,a5
	add.w	#$4000,a5
	move.b	(a5),(a0)	
	bra	start2

BROMs:
	move.l	a0,a5
	add.w	#$6000,a5
	move.b	(a5),(a0)
	bra	start2

MCR:
	move.b	(a0),d7
	and.l	#240,d7
	lsl.l	#6,d7
	move.w	MCRLast,d5
	move.w	d7,MCRLast
	move.w	#249,d6
	move.l	#$04040404,a5
.lp	move.l	#0,(a6,d5.w)
	move.l	a5,(a6,d7.w)
	addq.l	#4,d7
	addq.l	#4,d5
	dbra	d6,.lp
	bra	start2			; IMPLEMENT *****
MCRLast	dc.w	1024

BorderCol:
	move.b	(a0),d7
	and.l	#15,d7
	lea	Palette,a5
	move.w	(a5,d7.l*2),$dff180
	move.w	(a5,d7.l*2),Col0
	bra	start2

ScreenCol:
	move.b	(a0),d7
	and.l	#15,d7
	lea	Palette,a5
	move.w	(a5,d7.l*2),$dff1A0
	move.w	(a5,d7.l*2),Col1
	bra	start2

DoScreen:
	movem.l	d6/a0,-(sp)
	moveq	#0,d5
	and.l	#$ffff,d6
	move.b	(a0),d5
	lsl.l	#3,d5
	lea	ScrLUT,a0
	add.l	address,d5
	add.l	#$14000,d5
	sub.l	#1024,d6
	lsl.l	#1,d6
	move.l	screenhd,a5
	move.l	$c0(a5),a5
	moveq	#0,d7
	move.w	(a0,d6.l),d7
	add.l	d7,a5
	moveq	#3,d7
	move.l	d5,a0
.loop	
	move.b	(a0)+,(a5)
	add.l	#40,a5
	move.b	(a0)+,(a5)
	add.l	#40,a5
	dbra	d7,.loop
	movem.l	(sp)+,d6/a0
	bra	start2

DOIRQ:
	move.l	#0,ISData		;FIX ME and RTI
	btst	#16,d3			***************
	bne	start1
	bset	#16,d3
	subq.l	#1,a3
	move.w	a4,(a3)
	move.b	d3,-(a3)
	subq.l	#1,a3
	move.w	#$fffe,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a4
	bra	start1

InitSID:
	rts		
SIDInt:
	movem.l	d0-a6,-(sp)
	move.l	address,a0	; get pointer to C64 memory
	add.l	#54272,a0	; point to beginning of SID area
	moveq	#0,d0
	move.b	1(a0),d0
	lsl.l	#8,d0
	move.b	(a0),d0		; get voice 1 freq. Put into D0
	addq.l	#2,a0
	moveq	#0,d1
	move.b	1(a0),d1
	lsl.l	#8,d1
	move.b	(a0),d1		; get voice 1 pulse width. Put into D1
	addq.l	#2,a0
	move.l	(a0),d2		; d2 is control + A/D + S/R MSB-LSB (I think ;)
	btst	#28,d2
	movem.l	(sp)+,d0-a6
	rts			; CHANGE to RTE later maybe - depends on what
				; calls it

FlagNZ	Macro
	move	ccr,d5
	and.w	#12,d5
	and.w	#3,d3
	or.b	d5,d3
	ENDM

FlagCNZ	Macro
	move	ccr,d5
	and.w	#13,d5
	and.w	#2,d3
	or.b	d5,d3
	ENDM

FlagCMP	Macro
	move	ccr,d5
	and.w	#13,d5
	eor.b	#1,d5
	and.w	#2,d3
	or.b	d5,d3
	ENDM

FlagSUB	Macro
	eor.b	#1,d3
	lsr.b	d3
	subx.b	d6,d0
	move	ccr,d3
	eor.b	#1,d3
	tst.b	d0
	move	ccr,d5
	or.b	d5,d3
	ENDM

FlagADD Macro
	lsr.b	d3
	addx.b	d6,d0
	move	ccr,d3
	ENDM

FlagROL	Macro
	move.w	d3,d5
	lsr.b	d5
	roxl.b	\1
	move	ccr,d5
	and.w	#13,d5
	and.w	#2,d3
	or.b	d5,d3
	ENDM

FlagROR Macro
	move.w	d3,d5
	lsr.b	d5
	roxr.b	\1
	move	ccr,d5
	and.w	#13,d5
	and.w	#2,d3
	or.b	d5,d3
	ENDM

FlagLSR	Macro
	move	ccr,d5
	and.w	#2,d3
	and.w	#5,d5
	or.b	d5,d3
	ENDM

Rts:
	move.l	#0,a5
	move.l	a3,d6
	cmp.w	#$1ff,d6
	beq.s	.return
	move.l	#1,a5
	addq.w	#1,a3
	move.w	(a3)+,d6
	subq.w	#1,a3
	move.l	d6,a4
	addq.w	#1,a4
.return
	rts

Brk:
	move.l	#0,a5
	rts

orax:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	or.b	(a0),d0
	FlagNZ
	rts

ascii:
	move.l	#0,a5
	rts

oraz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	or.b	(a0),d0
	FlagNZ
	rts

aslz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	asl.b	d6
	FlagCNZ
	move.b	d6,(a0)
	move.w	#$ff,d7
	rts

php:
	move.b	d3,(a3)
	subq.w	#1,a3
	rts

orah:
	or.b	(a4)+,d0
	FlagNZ
	rts

asla:
	asl.b	d0
	FlagCNZ
	rts

ora:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	or.b	(a0),d0
	FlagNZ
	rts

asl:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	asl.b	d6
	FlagCNZ
	move.b	d6,(a0)
	move.w	#$ff,d7
	rts

bpl:
	btst	#3,d3
	bne.s	.nobra
	move.b	(a4)+,d6
	ext.w	d6
	add.w	d6,a4
	rts
.nobra	
	addq.w	#1,a4
	rts

oray:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	or.b	(a0),d0
	FlagNZ
	rts

orax1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	or.b	(a0),d0
	FlagNZ
	rts

aslx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	asl.b	d6
	FlagCNZ
	move.b	d6,(a0)
	move.w	#$ff,d7
	rts

clc:
	bclr	#0,d3
	rts

oray1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	or.b	(a0),d0
	FlagNZ
	rts

orax1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	or.b	(a0),d0
	FlagNZ
	rts

aslx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	(a0),d6
	asl.b	d6
	FlagCNZ
	move.b	d6,(a0)
	move.w	#$ff,d7
	rts

jsr:
	move.w	(a4)+,d6
	ror.w	#8,d6
	subq.w	#1,a4
	move.w	a4,d7
	subq.w	#1,a3
	move.w	d7,(a3)
	subq.w	#1,a3
	move.l	d6,a4
	rts

andx:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	and.b	(a0),d0
	FlagNZ
	rts

bitz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d7
	move.b	d7,d6
	and.b	#1,d3
	and.b	#128,d6
	lsr.b	#4,d6
	or.b	d6,d3
	move.b	d7,d6
	and.b	#64,d6
	lsr.b	#5,d6
	or.b	d6,d3
	and.b	d0,d7
	beq.s	.zero
	bclr	#2,d3
	rts
.zero
	bset	#2,d3
	rts

andz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	and.b	(a0),d0
	FlagNZ
	rts

rolz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagROL	d6
	move.b	d6,(a0)
	move.w	#$ff,d7
	rts

plp:
	addq.w	#1,a3
	move.b	(a3),d3
	rts

andh:
	and.b	(a4)+,d0
	FlagNZ
	rts

rola:
	FlagROL	d0
	rts

bit:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d7
	move.b	d7,d6
	and.b	#1,d3
	and.b	#128,d6
	lsr.b	#4,d6
	or.b	d6,d3
	move.b	d7,d6
	and.b	#64,d6
	lsr.b	#5,d6
	or.b	d6,d3
	and.b	d0,d7
	beq.s	.zero
	bclr	#2,d3
	rts
.zero
	bset	#2,d3
	rts

and:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	and.b	(a0),d0
	FlagNZ
	rts

rol:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagROL	d6
	move.b	d6,(a0)
	move.w	#$ff,d7
	rts

bmi:
	btst	#3,d3
	beq.s	.nobra
	move.b	(a4)+,d6
	ext.w	d6
	add.w	d6,a4
	rts
.nobra	
	addq.w	#1,a4
	rts

andy:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	and.b	(a0),d0
	FlagNZ
	rts

andx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	and.b	(a0),d0
	FlagNZ
	rts

rolx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagROL	d6
	move.b	d6,(a0)
	move.w	#$ff,d7
	rts

sec:
	bset	#0,d3
	rts

andy1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	and.b	(a0),d0
	FlagNZ
	rts

andx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	and.b	(a0),d0
	FlagNZ
	rts

rolx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagROL	d6
	move.b	d6,(a0)
	move.w	#$ff,d7
	rts

rti:
	addq.w	#1,a3
	move.b	(a3)+,d3
	move.w	(a3)+,d6
	move.l	d6,a4
	subq.w	#1,a3
	rts

eorx:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	eor.b	d6,d0
	FlagNZ
	rts

eorz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	eor.b	d6,d0
	FlagNZ
	rts

lsrz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsr.b	d6
	FlagLSR
	move.b	d6,(a0)
	move.w	#$ff,d7
	rts

pha:
	move.b	d0,(a3)
	subq.w	#1,a3
	rts

eorh:
	move.b	(a4)+,d6
	eor.b	d6,d0
	FlagNZ
	rts

lsra:
	lsr.b	d0
	FlagLSR
	rts

jmp:
	move.w	(a4),d6
	ror.w	#8,d6
	move.l	d6,a4
	rts

eor:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	eor.b	d6,d0
	FlagNZ
	rts

lsr:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsr.b	d6
	FlagLSR
	move.b	d6,(a0)
	move.w	#$ff,d7
	rts
	
bvc:
	btst	#1,d3
	bne.s	.nobra
	move.b	(a4)+,d6
	ext.w	d6
	add.w	d6,a4
	rts
.nobra	
	addq.w	#1,a4
	rts

eory:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d6
	eor.b	d6,d0
	FlagNZ
	rts

eorx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	eor.b	d6,d0
	FlagNZ
	rts

lsrx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsr.b	d6
	FlagLSR
	move.b	d6,(a0)
	move.w	#$ff,d7
	rts

cli:
	bclr	#16,d3
	rts

eory1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d6
	eor.b	d6,d0
	FlagNZ
	rts

eorx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	(a0),d6
	eor.b	d6,d0
	FlagNZ
	rts

lsrx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsr.b	d6
	FlagLSR
	move.b	d6,(a0)
	move.w	#$ff,d7
	rts

adcx:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagADD
	rts

adcz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagADD
	rts

rorz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagROR	d6
	move.b	d6,(a0)
	move.w	#$ff,d7
	rts

pla:
	addq.w	#1,a3
	move.b	(a3),d0
	FlagNZ
	rts

adch:
	move.b	(a4)+,d6
	FlagADD
	rts
	
rora:
	FlagROR	d0
	rts

jmpi:
	move.w	(a4),d6
	ror.w	#8,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a4
	rts

adc:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagADD
	rts

ror:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagROR	d6
	move.b	d6,(a0)
	move.w	#$ff,d7
	rts

bvs:
	btst	#1,d3
	beq.s	.nobra
	move.b	(a4)+,d6
	ext.w	d6
	add.w	d6,a4
	rts
.nobra	
	addq.w	#1,a4
	rts

adcy:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagADD
	rts

adcx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagADD
	rts

rorx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagROR	d6
	move.b	d6,(a0)
	move.w	#$ff,d7
	rts

sei:
	bset	#16,d3
	rts

adcy1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagADD
	rts

adcx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagADD
	rts	
	
rorx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagROR	d6
	move.b	d6,(a0)
	move.w	#$ff,d7
	rts

stax:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	d0,(a0)
	move.w	#$ff,d7
	rts

styz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	d2,(a0)
	move.w	#$ff,d7
	rts

staz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	d0,(a0)
	move.w	#$ff,d7
	rts

stxz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	d1,(a0)
	move.w	#$ff,d7
	rts

dey:
	subq.b	#1,d2
	FlagNZ
	rts

txa:
	move.b	d1,d0
	FlagNZ
	rts

sty:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	d2,(a0)
	move.w	#$ff,d7
	rts

sta:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	d0,(a0)
	move.w	#$ff,d7
	rts

stx:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	d1,(a0)
	move.w	#$ff,d7
	rts	

bcc:
	btst	#0,d3
	bne.s	.nobra
	move.b	(a4)+,d6
	ext.w	d6
	add.w	d6,a4
	rts
.nobra
	addq.w	#1,a4
	rts

stay:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	d0,(a0)
	move.w	#$ff,d7
	rts

styx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	d2,(a0)
	move.w	#$ff,d7
	rts

stax1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	d0,(a0)
	move.w	#$ff,d7
	rts

stxy1z:
	move.w	d2,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	d1,(a0)
	move.w	#$ff,d7
	rts

tya:
	move.b	d2,d0
	FlagNZ
	rts

stay1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	d0,(a0)
	move.w	#$ff,d7
	rts

txs:
	move.w	d1,a3
	add.w	#256,a3
	add.l	address,a3
	rts

stax1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	d0,(a0)
	move.w	#$ff,d7
	rts
	
Ldyh:
	move.b	(a4)+,d2
	FlagNZ
	rts

ldax:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d0
	FlagNZ
	rts

Ldxh:
	move.b	(a4)+,d1
	FlagNZ
	rts

ldyz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d2
	FlagNZ
	rts

ldaz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d0
	FlagNZ
	rts

ldxz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d1
	FlagNZ
	rts

tay:
	move.b	d0,d2
	FlagNZ
	rts
			
Ldah:
	move.b	(a4)+,d0
	FlagNZ
	rts

tax:
	move.b	d0,d1
	FlagNZ
	rts

ldy:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d2
	FlagNZ
	rts

lda:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d0
	FlagNZ
	rts

ldx:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d1
	FlagNZ
	rts

bcs:
	btst	#0,d3
	beq.s	.nobra
	move.b	(a4)+,d6
	ext.w	d6
	add.w	d6,a4
	rts
.nobra	
	addq.w	#1,a4
	rts

lday:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d0
	FlagNZ
	rts

ldyx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d2
	FlagNZ
	rts

ldax1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d0
	FlagNZ
	rts

ldxy1z:
	move.w	d2,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d1
	FlagNZ
	rts

clv:
	bclr	#1,d3
	rts

lday1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d0
	FlagNZ
	rts

tsx:
	move.w	a3,d1
	sub.w	#256,d1
	FlagNZ
	rts

ldyx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	(a0),d2
	FlagNZ
	rts

ldax1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	(a0),d0
	FlagNZ
	rts

ldxy1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d1
	FlagNZ
	rts

cpyh:
	cmp.b	(a4)+,d2
	FlagCMP
	rts

cmpx:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	cmp.b	(a0),d0
	FlagCMP
	rts
	
cpyz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	cmp.b	(a0),d2
	FlagCMP
	rts

cmpz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	cmp.b	(a0),d0
	FlagCMP
	rts

decz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	subq.b	#1,(a0)
	FlagNZ
	move.w	#$ff,d7
	rts

iny:
	addq.b	#1,d2
	FlagNZ
	rts

cmph:
	cmp.b	(a4)+,d0
	FlagCMP
	rts

dex:
	subq.b	#1,d1
	FlagNZ
	rts

cpy:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	cmp.b	(a0),d2
	FlagCMP
	rts

cmp:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	cmp.b	(a0),d0
	FlagCMP
	rts

dec:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	subq.b	#1,(a0)
	FlagNZ
	move.w	#$ff,d7
	rts

bne:
	btst	#2,d3
	bne.s	.nobra
	move.b	(a4)+,d6
	ext.w	d6
	add.w	d6,a4
	rts
.nobra	
	addq.w	#1,a4
	rts
	
cmpy:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	cmp.b	(a0),d0
	FlagCMP
	rts

cmpx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	cmp.b	(a0),d0
	FlagCMP
	rts

decx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	subq.b	#1,(a0)
	FlagNZ
	move.w	#$ff,d7
	rts

cld:
	bclr	#18,d3
	rts

cmpy1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	cmp.b	(a0),d0
	FlagCMP
	rts

cmpx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	cmp.b	(a0),d0
	FlagCMP
	rts

decx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	subq.b	#1,(a0)
	FlagNZ
	move.w	#$ff,d7
	rts

cpxh:
	cmp.b	(a4)+,d1
	FlagCMP
	rts

sbcx:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagSUB
	rts

cpxz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	cmp.b	(a0),d1
	FlagCMP
	rts

sbcz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagSUB
	rts

incz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	addq.b	#1,(a0)
	FlagNZ
	move.w	#$ff,d7
	rts

inx:
	addq.b	#1,d1
	FlagNZ
	rts

sbch:
	move.b	(a4)+,d6
	FlagSUB
	rts

nop:
	rts

cpx:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	cmp.b	(a0),d1
	FlagCMP
	rts

sbc:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagSUB
	rts

inc:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	addq.b	#1,(a0)
	FlagNZ
	move.w	#$ff,d7
	rts

beq:
	btst	#2,d3
	beq.s	.nobra
	move.b	(a4)+,d6
	ext.w	d6
	add.w	d6,a4
	rts
.nobra	
	addq.w	#1,a4
	rts

sbcy:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagSUB
	rts

sbcx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagSUB
	rts

incx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	addq.b	#1,(a0)
	FlagNZ
	move.w	#$ff,d7
	rts

sed:
	bset	#18,d3
	rts

sbcy1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagSUB
	rts

sbcx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagSUB
	rts

incx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	addq.b	#1,(a0)
	FlagNZ
	move.w	#$ff,d7
	rts

consolname:	dc.b	'CON:0/100/640/100/Debug',0
		even
conhandle:	dc.l	0
		
dosname:	dc.b	'dos.library',0
		even
dosbase:	dc.l	0

intuname:	dc.b	'intuition.library',0
		even
intbase:	dc.l	0

gfxname:	dc.b	'graphics.library',0
		even
gfxbase:	dc.l	0

sfxname:	dc.b	'specialfx.library',0
		even
sfxbase:	dc.l	0

windowhd:	dc.l	0

filehd:		dc.l	0

test:		dc.l	0

kernel:		dc.b	'ASMINCLUDE:64KernelROM',0

basic:		dc.b	'ASMINCLUDE:64BasicROM',0

char:		dc.b	'ASMINCLUDE:64CharROM',0

errmsg:		dc.b	"I/O Error!",0
		even
address:	dc.l	0

taskpt:		dc.l	0

taskoldwin:	dc.l	0

linef:		dc.b	10,13

buffer:		dcb.b	10,0
		even
screen_defs:
		dc.w	0
		dc.w	-5
		dc.w	320
		dc.w	256
		dc.w	5		;no of bpls
		dc.b	17		;colour of text
		dc.b	16		;bkgrnd colour
		dc.w	0
		dc.w	256
		dc.l	0
		dc.l	screenname
		dc.l	0
		dc.l	0

window_defs:
		dc.w	0,0
		dc.w	320,200
		dc.b	0,1
		dc.l	0
		dc.l	$11900
		dc.l	0
		dc.l	0
		dc.l	0
screenhd:	dc.l	0
		dc.l	0
		dc.w	320,200
		dc.w	320,200
		dc.w	15

screenname:	dc.b	'64 Emulator',0

colour64:
; 0 - 15
		dcb.w	16,0		;16 blacks
; 16 -31
Palette:	dc.w	$0000		;black
		dc.w	$0fff		;white
		dc.w	$0c34		;red
		dc.w	$03dc		;cyan
		dc.w	$0b6d		;purple
		dc.w	$05c5		;green
		dc.w	$045f		;blue
		dc.w	$0ef7		;yellow
		dc.w	$0d84		;orange
		dc.w	$0964		;brown
		dc.w	$0f77		;lt red
		dc.w	$0666		;grey1
		dc.w	$0999		;grey2
		dc.w	$09fa		;lt green
		dc.w	$089e		;lt blue
		dc.w	$0ccc		;grey3

table:
	dc.l	Brk
	dc.l	orax
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	oraz
	dc.l	aslz
	dc.l	ascii
	dc.l	php
	dc.l	orah
	dc.l	asla
	dc.l	ascii
	dc.l	ascii
	dc.l	ora
	dc.l	asl
	dc.l	ascii
	dc.l	bpl
	dc.l	oray
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	orax1z
	dc.l	aslx1z
	dc.l	ascii
	dc.l	clc
	dc.l	oray1
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	orax1
	dc.l	aslx1
	dc.l	ascii
	dc.l	jsr
	dc.l	andx
	dc.l	ascii
	dc.l	ascii
	dc.l	bitz
	dc.l	andz
	dc.l	rolz
	dc.l	ascii
	dc.l	plp
	dc.l	andh
	dc.l	rola
	dc.l	ascii
	dc.l	bit
	dc.l	and
	dc.l	rol
	dc.l	ascii
	dc.l	bmi
	dc.l	andy
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	andx1z
	dc.l	rolx1z
	dc.l	ascii
	dc.l	sec
	dc.l	andy1
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	andx1
	dc.l	rolx1
	dc.l	ascii
	dc.l	rti
	dc.l	eorx
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	eorz
	dc.l	lsrz
	dc.l	ascii
	dc.l	pha
	dc.l	eorh
	dc.l	lsra
	dc.l	ascii
	dc.l	jmp
	dc.l	eor
	dc.l	lsr
	dc.l	ascii
	dc.l	bvc
	dc.l	eory
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	eorx1z
	dc.l	lsrx1z
	dc.l	ascii
	dc.l	cli
	dc.l	eory1
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	eorx1
	dc.l	lsrx1
	dc.l	ascii
	dc.l	rts
	dc.l	adcx
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	adcz
	dc.l	rorz
	dc.l	ascii
	dc.l	pla
	dc.l	adch
	dc.l	rora
	dc.l	ascii
	dc.l	jmpi
	dc.l	adc
	dc.l	ror
	dc.l	ascii
	dc.l	bvs
	dc.l	adcy
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	adcx1z
	dc.l	rorx1z
	dc.l	ascii
	dc.l	sei
	dc.l	adcy1
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	adcx1
	dc.l	rorx1
	dc.l	ascii
	dc.l	ascii
	dc.l	stax
	dc.l	ascii
	dc.l	ascii
	dc.l	styz
	dc.l	staz	;133
	dc.l	stxz
	dc.l	ascii
	dc.l	dey
	dc.l	ascii
	dc.l	txa	;138
	dc.l	ascii
	dc.l	sty
	dc.l	sta
	dc.l	stx
	dc.l	ascii
	dc.l	bcc
	dc.l	stay
	dc.l	ascii
	dc.l	ascii
	dc.l	styx1z
	dc.l	stax1z
	dc.l	stxy1z
	dc.l	ascii
	dc.l	tya
	dc.l	stay1
	dc.l	txs
	dc.l	ascii
	dc.l	ascii
	dc.l	stax1
	dc.l	ascii
	dc.l	ascii
	dc.l	ldyh
	dc.l	ldax
	dc.l	ldxh
	dc.l	ascii
	dc.l	ldyz
	dc.l	ldaz	;165
	dc.l	ldxz
	dc.l	ascii
	dc.l	tay
	dc.l	ldah
	dc.l	tax
	dc.l	ascii
	dc.l	ldy
	dc.l	lda
	dc.l	ldx
	dc.l	ascii
	dc.l	bcs
	dc.l	lday
	dc.l	ascii
	dc.l	ascii
	dc.l	ldyx1z
	dc.l	ldax1z
	dc.l	ldxy1z
	dc.l	ascii
	dc.l	clv
	dc.l	lday1
	dc.l	tsx
	dc.l	ascii
	dc.l	ldyx1
	dc.l	ldax1
	dc.l	ldxy1
	dc.l	ascii
	dc.l	cpyh
	dc.l	cmpx
	dc.l	ascii
	dc.l	ascii
	dc.l	cpyz
	dc.l	cmpz
	dc.l	decz
	dc.l	ascii
	dc.l	iny
	dc.l	cmph
	dc.l	dex
	dc.l	ascii
	dc.l	cpy
	dc.l	cmp
	dc.l	dec
	dc.l	ascii
	dc.l	bne
	dc.l	cmpy
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	cmpx1z
	dc.l	decx1z
	dc.l	ascii
	dc.l	cld
	dc.l	cmpy1
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	cmpx1
	dc.l	decx1
	dc.l	ascii
	dc.l	cpxh
	dc.l	sbcx
	dc.l	ascii
	dc.l	ascii
	dc.l	cpxz
	dc.l	sbcz
	dc.l	incz
	dc.l	ascii
	dc.l	inx	;232
	dc.l	sbch
	dc.l	nop
	dc.l	ascii
	dc.l	cpx
	dc.l	sbc
	dc.l	inc
	dc.l	ascii
	dc.l	beq	;240
	dc.l	sbcy
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	sbcx
	dc.l	incx1z
	dc.l	ascii
	dc.l	sed
	dc.l	sbcy1
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	sbcx1
	dc.l	incx1
	dc.l	ascii


	cnop	0,4
	
COP_IS:
	dc.l	0,0
	dc.b	2,20
	dc.l	CName
	dc.l	ISData,ISInterrupt
CName:	dc.b	"42-Interrupt",0
	even
ISData:	dc.l	0
Col0:	dc.w	0	; colour00
Col1:	dc.w	0	; colour16
	even
FXError:
	dc.l	0
FX_Handle:
	dc.l	0
FX_DHandle:
	dc.l	0
FXTags:
	dc.l	SFX_InstallEffect
FXaddy:	dc.l	0
	dc.l	0
	dc.l	0

code:
	dc.b	169,3,160,$e8,32,$91,$b3,32,$9b,$bc,96
;	dc.b	169,5,141,32,208,96
;	dc.b	169,$fa,24,105,5,96
;	dc.b	169,81,141,0,4,238,3,192,208,248,238,4,192
;	dc.b	173,4,192,201,159,208,238,96
;	dc.b	$ee,$21,$d0,$4c,$00,$c0
	dc.b	255,255
	cnop	0,4
ReadBase:
	dcb.b	256,0
WriteBase:
	dc.l	start2		; 0
	dc.l	KROMS		; 1
	dc.l	RasterW		; 2
	dc.l	BROMS		; 3
	dc.l	DoScreen	; 4
	dc.l	MCR		; 5
	dc.l	BorderCol	; 6
	dc.l	ScreenCol	; 7
	dc.l	stop
	dcb.l	256,start2

ScrLUT:	dcb.l	1000,0
	

